/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.data.recipe.builder;

import cloud.lemonslice.teastory.recipe.stone_mill.StoneRollerRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.registry.RecipeRegister;

public class StoneRollerRecipeBuilder {
    private final Ingredient inputItem;
    private final NonNullList<ItemStack> outputItems;
    private final int workTime;

    private StoneRollerRecipeBuilder(Ingredient inputItem, NonNullList<ItemStack> outputItems, int workTime) {
        this.inputItem = inputItem;
        this.outputItems = outputItems;
        this.workTime = workTime;
    }

    public static StoneRollerRecipeBuilder recipe(int workTime, Ingredient inputItem, ItemStack ... outputItems) {
        return new StoneRollerRecipeBuilder(inputItem, (NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])outputItems), workTime);
    }

    public static StoneRollerRecipeBuilder recipeWithDefaultTime(Ingredient inputItem, ItemStack ... outputItems) {
        return StoneRollerRecipeBuilder.recipe(200, inputItem, outputItems);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation saveRes = ResourceLocation.m_135820_((String)save);
        this.build(consumerIn, saveRes);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.inputItem, this.outputItems, this.workTime));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        protected final Ingredient inputItem;
        protected final NonNullList<ItemStack> outputItems;
        protected final int workTime;
        private final RecipeSerializer<StoneRollerRecipe> serializer = (RecipeSerializer)RecipeRegister.STONE_ROLLER_SERIALIZER.get();

        public Result(ResourceLocation idIn, Ingredient inputItem, NonNullList<ItemStack> outputItems, int workTime) {
            this.id = TeaStory.rl(idIn.m_135827_(), "stone_roller/" + idIn.m_135815_());
            this.inputItem = inputItem;
            this.outputItems = outputItems;
            this.workTime = workTime;
        }

        public void m_7917_(JsonObject json) {
            if (!this.inputItem.checkInvalidation()) {
                json.add("item_ingredient", this.inputItem.m_43942_());
            }
            JsonArray jsonarray = new JsonArray();
            for (ItemStack itemStack : this.outputItems) {
                JsonObject jsonItem = new JsonObject();
                jsonItem.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
                if (itemStack.m_41613_() > 1) {
                    jsonItem.addProperty("count", (Number)itemStack.m_41613_());
                }
                jsonarray.add((JsonElement)jsonItem);
            }
            json.add("output_items", (JsonElement)jsonarray);
            json.addProperty("work_time", (Number)this.workTime);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

